import nextPlugin from '@next/eslint-plugin-next'
import monorepoPlugin from 'eslint-plugin-monorepo'
import perfectionistPlugin from 'eslint-plugin-perfectionist'
import prettierPlugin from 'eslint-plugin-prettier'
import reactPlugin from 'eslint-plugin-react'
import reactHooksPlugin from 'eslint-plugin-react-hooks'
import typescriptPlugin from 'typescript-eslint'

export default [
	// Global ignores - these files are completely ignored by ESLint
	{
		ignores: [
			'**/.next/**/*',
			'**/node_modules/**/*',
			'**/dist/**/*',
			'**/build/**/*',
			'**/generated/**/*',
			'**/coverage/**/*',
			'**/*.log',
			'**/.env*',
			'**/public/**/*',
			'**/.git/**/*',
			// Ignore config files
			'*.config.ts',
			'*.config.mjs',
			'postcss.config.js',
			'prettier.config.js',
			'tailwind.config.ts',
			'**/messy/**/*',
		],
	},
	{
		files: ['src/**/*.{js,jsx,ts,tsx}', 'scripts/**/*.{js,jsx,ts,tsx}'],
		languageOptions: {
			parser: typescriptPlugin.parser,
			parserOptions: {
				ecmaFeatures: { jsx: true },
				project: true,
			},
		},
		plugins: {
			'@typescript-eslint': typescriptPlugin.plugin,
			monorepo: monorepoPlugin,
			'@next/next': nextPlugin,
			perfectionist: perfectionistPlugin,
			prettier: prettierPlugin,
			react: reactPlugin,
			reactHooks: reactHooksPlugin,
		},
		rules: {
			// ...nextPlugin.configs.recommended.rules,
			// ...nextPlugin.configs['core-web-vitals'].rules,
			'comma-dangle': ['error', 'always-multiline'],
			curly: ['error', 'multi-line'],
			'monorepo/no-internal-import': 'off',
			'monorepo/no-relative-import': 'off',
			'no-unused-vars': 'off',
			'perfectionist/sort-imports': [
				'error',
				{
					type: 'alphabetical',
					order: 'asc',
					ignoreCase: true,
					groups: [
						'react-import',
						'type-import',
						['value-builtin', 'value-external'],
						'workspace-imports',
						'app-imports',
						'component-imports',
						'hook-imports',
						'page-imports',
						'lib-imports',
						'utils-imports',
						'style-imports',
						'css-imports',
						'script-imports',
						'relative-imports',
						'unknown',
					],
					customGroups: [
						{
							groupName: 'react-import',
							elementNamePattern: '^\\* as React from [\'"]react[\'"]$',
						},
						{
							groupName: 'type-import',
							elementNamePattern: '^type\\s',
						},
						{
							groupName: 'workspace-imports',
							elementNamePattern: '^@monorepo/.+',
						},
						{
							groupName: 'app-imports',
							elementNamePattern: '^@/app/.+',
						},
						{
							groupName: 'component-imports',
							elementNamePattern: '^@/components/.+',
						},
						{
							groupName: 'hook-imports',
							elementNamePattern: '^@/hooks|^@/hooks/.+',
						},
						{
							groupName: 'page-imports',
							elementNamePattern: '^@/pages/.+',
						},
						{
							groupName: 'lib-imports',
							elementNamePattern: '^@/lib/.+',
						},
						{
							groupName: 'utils-imports',
							elementNamePattern: '^@/utils|^@/utils/.+',
						},
						{
							groupName: 'style-imports',
							elementNamePattern: '^@/styles/.+',
						},
						{
							groupName: 'css-imports',
							elementNamePattern: '^[\\-@/a-zA-Z0-9]+?\\.css$',
						},
						{
							groupName: 'script-imports',
							elementNamePattern: '^scripts/.+',
						},
						{
							groupName: 'relative-imports',
							elementNamePattern: '^[./]',
						},
					],
				},
			],
			'perfectionist/sort-interfaces': [
				'error',
				{
					type: 'alphabetical',
					order: 'asc',
					ignoreCase: true,
				},
			],
			'perfectionist/sort-jsx-props': [
				'error',
				{
					type: 'alphabetical',
					order: 'asc',
					ignoreCase: true,
					groups: ['model-prop', 'key-prop', 'id-prop', 'unknown'],
					customGroups: [
						{
							groupName: 'model-prop',
							elementNamePattern: '^model$',
						},
						{
							groupName: 'key-prop',
							elementNamePattern: '^key$',
						},
						{
							groupName: 'id-prop',
							elementNamePattern: '^id$',
						},
					],
				},
			],
			'perfectionist/sort-object-types': [
				'error',
				{
					type: 'alphabetical',
					order: 'asc',
					ignoreCase: true,
					groups: ['id-prop'],
					customGroups: [
						{
							groupName: 'id-prop',
							elementNamePattern: '^id$',
						},
					],
				},
			],
			'perfectionist/sort-objects': [
				'error',
				{
					type: 'alphabetical',
					order: 'asc',
					ignoreCase: true,
					partitionByComment: false,
					partitionByNewLine: false,
					groups: [
						'method-prop',
						'headers-prop',
						'body-prop',
						'id-prop',
						'ai-model-prop',
						'prisma-where-prop',
						'prisma-data-prop',
						'prisma-create-prop',
						'prisma-update-prop',
						'prisma-take-prop',
						'prisma-orderby-prop',
						'prisma-select-prop',
						'prisma-cachestrategy-prop',
						'unknown',
					],
					customGroups: [
						{
							groupName: 'method-prop',
							elementNamePattern: '^method$',
						},
						{
							groupName: 'headers-prop',
							elementNamePattern: '^headers$',
						},
						{
							groupName: 'body-prop',
							elementNamePattern: '^body$',
						},
						{
							groupName: 'id-prop',
							elementNamePattern: '^id$',
						},
						{
							groupName: 'ai-model-prop',
							elementNamePattern: '^model$',
						},
						{
							groupName: 'prisma-where-prop',
							elementNamePattern: '^where$',
						},
						{
							groupName: 'prisma-data-prop',
							elementNamePattern: '^data$',
						},
						{
							groupName: 'prisma-create-prop',
							elementNamePattern: '^create$',
						},
						{
							groupName: 'prisma-update-prop',
							elementNamePattern: '^update$',
						},
						{
							groupName: 'prisma-take-prop',
							elementNamePattern: '^take$',
						},
						{
							groupName: 'prisma-orderby-prop',
							elementNamePattern: '^orderBy$',
						},
						{
							groupName: 'prisma-select-prop',
							elementNamePattern: '^select$',
						},
						{
							groupName: 'prisma-cachestrategy-prop',
							elementNamePattern: '^cacheStrategy$',
						},
					],
				},
			],
			'prettier/prettier': 'warn',
			quotes: [
				'error',
				'single',
				{ avoidEscape: true, allowTemplateLiterals: false },
			],
			'react/display-name': 'error',
			'react/jsx-key': 'error',
			'react/jsx-no-comment-textnodes': 'error',
			'react/jsx-no-duplicate-props': 'error',
			'react/jsx-no-target-blank': 'error',
			'react/jsx-no-undef': 'error',
			'react/jsx-uses-react': 'error',
			'react/jsx-uses-vars': 'error',
			'react/no-children-prop': 'error',
			'react/no-danger-with-children': 'error',
			'react/no-deprecated': 'error',
			'react/no-direct-mutation-state': 'error',
			'react/no-find-dom-node': 'error',
			'react/no-is-mounted': 'error',
			'react/no-render-return-value': 'error',
			'react/no-string-refs': 'error',
			'react/no-unescaped-entities': 'off',
			'react/no-unknown-property': 'error',
			'react/no-unsafe': 'error',
			'react/prop-types': 'off',
			'react/react-in-jsx-scope': 'off',
			'react/require-render-return': 'error',
			'@typescript-eslint/no-unused-vars': [
				'warn',
				{
					argsIgnorePattern: '^_',
					varsIgnorePattern: '^_',
					caughtErrorsIgnorePattern: '^_',
					ignoreRestSiblings: true,
					// Only check variables, not function parameters
					args: 'none',
					vars: 'all',
				},
			],
		},
		settings: {
			next: {
				rootDir: ['./app/'],
			},
			react: {
				version: 'detect',
			},
		},
	},
]
